<?php
/*--------------------------------------------------------------
   FetchSpecificProductVariantAction.php 2021-02-18
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Api\Modules\ProductVariant\App\Actions;

use Gambio\Admin\Modules\ProductVariant\Model\Exceptions\ProductVariantDoesNotExist;
use Gambio\Admin\Modules\ProductVariant\Services\ProductVariantsReadService as ProductVariantsReadServiceInterface;
use Gambio\Api\Application\Responses\CreateApiMetaDataTrait;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

/**
 * Class FetchSpecificProductVariantAction
 * @package Gambio\Api\Modules\ProductVariant\App\Actions
 */
class FetchSpecificProductVariantAction
{
    use CreateApiMetaDataTrait;
    
    /**
     * @var ProductVariantsReadServiceInterface
     */
    private $service;
    
    
    /**
     * FetchSpecificProductVariantAction constructor.
     *
     * @param ProductVariantsReadServiceInterface $service
     */
    public function __construct(
        ProductVariantsReadServiceInterface $service
    ) {
        $this->service = $service;
    }
    
    
    /**
     * @param Request  $request
     * @param Response $response
     * @param array    $args
     *
     * @return Response
     */
    public function __invoke(Request $request, Response $response, array $args): Response
    {
        try {
    
            $productId      = (int)$request->getAttribute('productId');
            $variantId      = (int)$request->getAttribute('variantId');
            $productVariant = $this->service->getProductVariantById($variantId);
            $metaData       = $this->createApiMetaData();
            
            if ($productVariant->productId() !== $productId) {
    
                return $response->withStatus(404);
            }
            
            return $response->withJson([
                                           'data'  => $productVariant->toArray(),
                                           '_meta' => $metaData,
                                       ]);
        } catch (ProductVariantDoesNotExist $exception) {
            
            return $response->withStatus(404);
        }
    }
}